/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-9,Gas Power Systems
//Example 9_1 Page:309
//Title:Analyzing the Otto Cycle
//===============================
package Ex9_1
  model Ex9_1_a
  //To find the temperature and pressure at the end of each process
  
    //parameter selection
    parameter Real r(unit = "-") = 8 "compression ratio";
    parameter Real p1(unit = "atm") = 1 "pressure at state 1";
    parameter Real T1(unit = "R") = 540 "temperature at state 1";
    parameter Real vr1(unit = "-") = 144.32 "specific relative volume at state 1";
                                                                        /*From Table A-22E at T=540 R. 
                                                                        Appendix Pg:A-89*/
    parameter Real T3(unit = "R") = 3600 "temperature at state 3";
    parameter Real vr3(unit = "-") = 0.6449 "specific relative volume at state 3";
                                                                        /*From Table A-22E at T=3600 R. 
                                                                        Appendix Pg:A-90*/
    parameter Real T2a(unit = "R") = 1200 "temperature a for state 2";
    parameter Real T2b(unit = "R") = 1240 "temperature b for state 2";
    parameter Real vr2a(unit = "-") = 18.51 "specific relative volume a for state 2";
    parameter Real vr2b(unit = "-") = 16.93 "specific relative volume b for state 2";  
                                                                        /*From Table-22E at vr2=18.04 for 
                                                                        interpolating T. Appendix Pg:A-89*/  
    parameter Real T4a(unit = "R") = 1850 "temperature a for state 4";
    parameter Real T4b(unit = "R") = 1900 "temperature b for state 4";
    parameter Real vr4a(unit = "-") = 5.388 "specific relative volume a for state 4";
    parameter Real vr4b(unit = "-") = 4.974 "specific relative volume b for state 4";
                                                                        /*From Table-22E at vr4=5.16 for 
                                                                        interpolating T. Appendix Pg:A-89*/ 
    //===============================
    
    //variable selection
    Real vr2(unit = "-") "specific relative volume at state 2";
    Real vr4(unit = "-") "specific relative volume at state 4";
    Real p2(unit = "atm") "pressure at state 2";
    Real p3(unit = "atm") "pressure at state 3";
    Real p4(unit = "atm") "pressure at state 4";
    Real T2(unit = "R") "temperature at state 2";
    Real T4(unit = "R") "temperature at state 4";
    //===============================
    
    //equation selection
  equation
    vr2 = vr1 / r;
    vr4 = vr3 * r;                                            //From Eq. 9.4, Pg:308
    p2 = p1 * (T2 / T1) * r;
    p3 = p2 * (T3 / T2);
    p4 = p1 * (T4 / T1);                                      //Ideal gas equation of state
    (T2 - T2a) / (T2b - T2a) = (vr2 - vr2a) / (vr2b - vr2a);
    (T4 - T4a) / (T4b - T4a) = (vr4 - vr4a) / (vr4b - vr4a);  //Interpolation
  end Ex9_1_a;
  //===============================

  model Ex9_1_b
    //To find thermal efficiency
    
    //parameter selection
    parameter Real u1(unit = "Btu/lb") = 92.04 "specific internal energy at state 1";
                                                                          /*From Table A-22E at T=540 R. 
                                                                          Appendix Pg:A-89*/
    parameter Real u4(unit = "Btu/lb") = 342.2 "specific internal energy at state 4";
                                                                          /*From Table A-22E at T=1878 R. 
                                                                          Appendix Pg:A-89*/
    parameter Real u3(unit = "Btu/lb") = 721.44 "specific internal energy at state 3";
                                                                          /*From Table A-22E at T=3600 R. 
                                                                          Appendix Pg:A-90*/
    parameter Real u2(unit = "Btu/lb") = 211.3 "specific internal energy at state 2";
                                                                          /*From Table A-22E at T=1212 R. 
                                                                          Appendix Pg:A-89*/
    //===============================
    
    //variable selection
    Real n(unit = "-") "thermal efficiency";
    //===============================
    
    //equation selection
    equation
    n = 1 - (u4 - u1) / (u3 - u2);          //Thermal efficiency
  end Ex9_1_b;

  //===============================

  model Ex9_1_c
    //To find mean effective pressure
    
    //===============================
    extends Ex9_1_a;
    extends Ex9_1_b;
    //===============================
    
    //parameter selection
    parameter Real V1(unit = "ft3") = 0.02 "volume of cylinder";
    final constant Real R(final unit = "ft.lbf/R.lb-mol") = 1545.33 "gas constant";
    final constant Real M(final unit = "lb/lb-mol") = 28.97 "molecular mass of air";
    //===============================
    
    //variable selection
    Real Wcycle(unit = "Btu") "net work per cycle";
    Real m(unit = "lb") "mass of air";
    Real mep(unit = "atm") "mean effective pressure";
    //===============================
    
    //equation selection
    equation
    m = p1 * 14.696 * 144 * V1 / (R / M * T1);      //Ideal gas equation of state
                                                    //Multiplying by 14.696 to convert into lbf/in^2
                                                    //Multiplying by 144 to convert into in^2
    Wcycle = m * (u3 - u4 - (u2 - u1));             //Net work per cycle
    mep = Wcycle / (V1 * (1 - 1 / r)) * (788 / 144) / 14.696;
                                                    //Mean effective pressure
                                                    //Multiplying by (778/144) to convert into lbf/in^2
                                                    //Dividing by 14.696 to convert into atm
  end Ex9_1_c;

  //===============================
end Ex9_1;
