/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-9,Gas Power Systems
//Example 9_11 Page:335
//Title:Analyzing a Regenerative Gas Turbine with Intercooling and Reheat
//===============================
package Ex9_11
  model Ex9_11_a
  //To find thermal efficiency
  
      //parameter selection
      parameter Real h1(unit = "kJ/kg") = 300.19 "specific enthalpy at state 1";
      parameter Real h2(unit = "kJ/kg") = 439.1 "specific enthalpy at state 2";
      parameter Real h2s(unit = "kJ/kg") = 411.3 "specific enthalpy at state 2s";
      parameter Real h3(unit = "kJ/kg") = 300.19 "specific enthalpy at state 3";
      parameter Real h4(unit = "kJ/kg") = 454.7 "specific enthalpy at state 4";
      parameter Real h4s(unit = "kJ/kg") = 423.8 "specific enthalpy at state 4s";
      parameter Real h5(unit = "kJ/kg") = 1055.1 "specific enthalpy at state 5";
      parameter Real h6(unit = "kJ/kg") = 1515.4 "specific enthalpy at state 6";
      parameter Real h7(unit = "kJ/kg") = 1179.8 "specific enthalpy at state 7";
      parameter Real h7s(unit = "kJ/kg") = 1095.9 "specific enthalpy at state 7s";
      parameter Real h8(unit = "kJ/kg") = 1515.4 "specific enthalpy at state 8";
      parameter Real h9(unit = "kJ/kg") = 1205.2 "specific enthalpy at state 9";
      parameter Real h9s(unit = "kJ/kg") = 1127.6 "specific enthalpy at state 9s";
                                                                   /*From Fig.E9.11 from Example 9.11. Pg:336*/
      //===============================
      
      //variable selection
      Real Wt_m(unit = "kJ/kg") "turbine work per unit of mass";
      Real Wc_m(unit = "kJ/kg") "compressor work per unit of mass";
      Real Qin_m(unit = "kJ/kg") "total heat added per unit of mass";
      Real n(unit = "-") "thermal efficiency";
      //===============================
      
      //equation selection
      equation
        Wt_m = h6 - h7 + h8 - h9;
        Wc_m = h2 - h1 + h4 - h3;
        Qin_m = h6 - h5 + h8 - h7;       //Reduced mass and energy balance
        n = (Wt_m - Wc_m) / Qin_m;       //Thermal efficiency
  end Ex9_11_a;
  //===============================
  
  model Ex9_11_b
  //To find back work ratio
      
      //===============================
      extends Ex9_11_a;
      //===============================
      
      //variable selection
      Real bwr(unit="-")"back work ratio";
      //===============================
      
      //equation selection
      equation
        bwr=Wc_m/Wt_m;    //Back work ratio
      
  end Ex9_11_b;
  //===============================

  model Ex9_11_c
  //To find the net power developed
  
      //===============================
      extends Ex9_11_a;
      //===============================
      
      //parameter selection
      parameter Real m(unit="kg/s")=5.807"mass flow rate";
      //===============================
      
      //variable selection
      Real Wcycle(unit="kW")"net poer developed";
      //===============================
      
      //equation selection
      equation
        Wcycle=m*(Wt_m-Wc_m);       //Net power developed
      
  end Ex9_11_c;
  //===============================
  
  model Ex9_11_d
  //To find total energy rate added by heat transfer
  
      //===============================
      extends Ex9_11_a;
      extends Ex9_11_c;
      //===============================
      
      //variable selection
      Real Qin(unit="kW")"total energy rate added by heat transfer";
      //===============================
      
      //equation selection
      equation
        Qin=m*(Qin_m);
      
  end Ex9_11_d;
  //===============================
end Ex9_11;
