/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-9,Gas Power Systems
//Example 9_14 Page:361
//Title:Determining the Effect of Back Pressure: Converging Nozzle
//===============================
package Ex9_14
  model Ex9_14_a
  //To find exit Mach number for back pressure 500 kPa
  
    //parameter selection
    parameter Real A2(unit = "m2") = 0.001 "converging nozzle exit area";
    parameter Real M(unit = "-") = 1.0 "Mach number";
    parameter Real k(unit = "-") = 1.4 "specific heat ratio";
    parameter Real p2(unit = "kPa") = 528 "critical pressure";          /*From T vs s graph in Ex 9.14. Pg:361*/
    parameter Real T0(unit = "K") = 360 "temperature at the inlet";
    final constant Real R(final unit = "J/kmol.K") = 8314 "gas constant";
    final constant Real Ma(final unit = "kg/kmol") = 28.97 "molecular mass of air";
                                                                        /*From Table A-1. Appendix Pg:A-2*/
    //===============================
    
    //variable selection
    Real ma(unit = "kg/s") "mass flow rate";
    Real V2(unit = "m/s") "exit velocity";
    Real T2(unit = "K") "exit temperature";
    //===============================
    
    //equation selection
    equation
      T2 = T0 / (1 + (k - 1) / 2 * M ^ 2);         //From Eq. 9.50, Pg:360
      V2 = (k * R / Ma * T2) ^ (1 / 2);            //From Eq. 9.37, Pg:352
      ma = p2 * 10 ^ 3 * A2 * V2 / (R / Ma * T2);  //Mass flow rate
  end Ex9_14_a;
  //===============================

  model Ex9_14_b
  //To find exit Mach number for back pressure 784 kPa
  
    //===============================  
    extends Ex9_14_a;
    //===============================
    
    //parameter selection
    parameter Real p0(unit="MPa")=1.0"inlet pressure of air";
    parameter Real p2b(unit="kPa")=784"exit pressure";
    //===============================
    
    //variable selection
    Real mb(unit = "kg/s") "mass flow rate";
    Real V2b(unit = "m/s") "exit velocity";
    Real T2b(unit = "K") "exit temperature";
    Real M2(unit="-")"exit Mach number";
    //===============================
    
    //equation selection
    equation
      M2=(2/(k-1)*((p0*10^3/p2b)^((k-1)/k)-1))^0.5;       //From Eq. 9.51, Pg:360
      V2b=M2*(k*R/Ma*T2b)^(1/2);                          //From Eq. 9.37 with Mach number, Pg:352
      T2b = T0 / (1 + (k - 1) / 2 * M2 ^ 2);              //From Eq. 9.50, Pg:360
      mb = p2b * 10 ^ 3 * A2 * V2b / (R / Ma * T2b);      //Mass flow rate
  end Ex9_14_b;
  //===============================
end Ex9_14;
