/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-9,Gas Power Systems
//Example 9_6 Page:324
//Title:Evaluating Performance of a Brayton Cycle with Irreversibilities
//===============================
package Ex9_6
  model Ex9_6_a
  //To find thermal efficiency
  
      //parameter selection
      parameter Real h1(unit = "kJ/kg") = 300.19 "specific enthalpy at state 1";    
                                                                      /*From Table A-22 at T=300 K. 
                                                                      Appendix Pg:A-39"*/
      parameter Real h3(unit = "kJ/kg") = 1515.4 "specific enthalpy at state 3";    
                                                                      /*From Table A-22 at T=1400 K. 
                                                                      Appendix Pg:A-40*/
      parameter Real nt(unit = "-") = 0.8 "isentropic turbine efficiency";
      parameter Real nc(unit = "-") = 0.8 "isentropic compressor efficiency";
      parameter Real Wt_ms(unit = "kJ/kg") = 706.9 "turbine work per unit mass without isentopic efficiency";
      parameter Real Wc_ms(unit = "kJ/kg") = 279.7 "compressor work per unit mass without isentopic efficiency";    
                                                                      /*From solution to Example 9.4, Pg:320*/
      //===============================
      
      //variable selection                                                           
      Real Wt_m(unit = "kJ/kg") "turbine work per unit mass";
      Real Wc_m(unit = "kJ/kg") "compressor work per unit mass";
      Real h2(unit = "kJ/kg") "specific enthalpy at state 2";
      Real Qin_m(unit = "kJ/kg") "heat transfer to the working fluid per unit mass";
      Real n(unit = "-") "thermal efficiency";
      //===============================
      
      //equation selection
      equation
        Wt_m = nc * Wt_ms;
        Wc_m = Wc_ms / nc;
        Wc_m = h2 - h1;
        Qin_m = h3 - h2;
        n = (Wt_m - Wc_m) / Qin_m;    //Thermal efficiency
  end Ex9_6_a;
  //===============================

  model Ex9_6_b
  //To find back work ratio
  
      //===============================
      extends Ex9_6_a;
      //===============================
      
      //variable selection
      Real bwr(unit="-")"back work ratio";
      //===============================
      
      //equation selection
      equation
        bwr=Wc_m/Wt_m;     //Back work ratio
      
  end Ex9_6_b;
  //===============================

  model Ex9_6_c
  //To find net power developed
      
      //===============================
      extends Ex9_6_a;
      //===============================
      
      //parameter selection
      parameter Real m(unit="kg/s")=5.807"mass flow rate";
      //===============================
      
      //variable selection
      Real Wcycle(unit="kW")"net power developed by the cycle";
      //===============================
      
      //equation selection
      equation
        Wcycle=m*(Wt_m-Wc_m);      //Net power developed
  end Ex9_6_c;
  //===============================
end Ex9_6;
