model Ex2_6

parameter Real hfe=100;
parameter Real hie=1100;
parameter Real R1(unit="ohm")=68000"Resistance";
parameter Real R2(unit="ohm")=22000"Resistance";
parameter Real RC(unit="ohm")=2200"Resistance";
parameter Real RL(unit="ohm")=10000"Resistance";
parameter Real Rs(unit="ohm")=680"Resistance";
parameter Real Cbc(unit="F")=4*10^(-12)"capacitance";
parameter Real pi=Modelica.Constants.pi;

Real Ri(unit="ohm")"Resistance";
Real Ro(unit="ohm")"Resistance";
Real Av"Gain";
Real Cin(unit="F")"capacitance";
Real Cout(unit="F")"capacitance";
Real fc_input(unit="Hz")"capacitance";
Real fc_output(unit="Hz")"capacitance";

equation

Av=-hfe*Ro/Ri;
Ri=hie*R1*R2/(hie*R1+hie*R2+R1*R2);
Ro=RC*RL/(RC+RL);
Cin=Cbc*(-Av+1);
Cout=Cbc*(-Av+1)/(-Av);
fc_input=1/(2*pi*(1/((1/Rs)+(1/R1)+(1/R2)+(1/hie)))*(Cbc+Cin));
fc_output=1/(2*pi*(RC*RL/(RC+RL))*Cout);

// There is round of error in the textbook

end Ex2_6;