model Ex3_11

parameter Real Rc2(unit="ohm")=4700"resistance";
parameter Real R(unit="ohm")=3300"resistance";
parameter Real hie(unit="ohm")=1000"resistance";
parameter Real Rc1(unit="ohm")=10000"resistance";
parameter Real R3(unit="ohm")=100000"resistance";
parameter Real R4(unit="ohm")=22000"resistance";
parameter Real Rs(unit="ohm")=120"resistance";
parameter Real hfe=50;

Real RL2(unit="ohm")"resistance";
Real Ai2;
Real Ri2(unit="ohm")"resistance";
Real Av2;
Real Ai1;
Real RL1(unit="ohm")"Resistance";
Real Ri1(unit="ohm")"Resistance";
Real Av1;
Real Av;
Real Bita;
Real D;
Real Avf;
Real Rif(unit="ohm")"resistance";
Real Ro_das(unit="ohm")"Resistance";
Real Rof_das(unit="ohm")"resistance";

equation

RL2=Rc2*(Rs+R)/(Rc2+Rs+R);
Ai2=-hfe;
Ri2=hie;
Av2=Ai2*RL2/Ri2;
Ai1=-hfe;
RL1=1/((1/Rc1)+(1/R3)+(1/R4)+(1/Ri2));
Ri1=hie+(1+hfe)*(Rs*R)/(Rs+R);
Av1=Ai1*RL1/Ri1;
Av=Av1*Av2;
Bita=Rs/(Rs+R);
D=1+Bita*Av;
Avf=Av/D;
Rif=Ri1*D;
Ro_das=RL2;
Rof_das=Ro_das/D;


end Ex3_11;