model Ex3_14

parameter Real Av_mid=500"Voltage gain";
parameter Real fL(unit="Hz")=100"low Frequency";
parameter Real fH(unit="Hz")=20*10^3"high Frequency";
parameter Real Bita=0.01;

Real Avf"Voltage gain with feedback";
Real f_Lf(unit="Hz")"Frequency";
Real f_Hf(unit="Hz")"Frequency";
Real BWf(unit="kHz")"new Bandwidth";

equation

Avf=Av_mid/(1+Bita*Av_mid);
f_Lf=fL/(1+Bita*Av_mid);
f_Hf=fH*(1+Bita*Av_mid);
BWf=(f_Hf-f_Lf)/1000;

end Ex3_14;