model Ex3_2

parameter Real Av=1000;
parameter Real Vs(unit="mV")=10"Voltage";
parameter Real W(unit="W")=10"Power";
parameter Real B=-40"Negative feedback";
parameter Real D2(unit="%")=10"Second harmonic distortion";

Real Bita;
Real Avf"Gain of the amplifier";
Real Vsf(unit="V")"output voltage with feedback";
Real D2f(unit="%")"Reduced Second harmonic distortion";

equation

B=20*log10(1/(1+Bita*Av));
Avf=Av/(1+Bita*Av);
Vsf=Vs*10^(-3)*(1+Av*Bita);
D2f=D2/(1+Bita*Av);

end Ex3_2;