model Ex3_4

parameter Real Rc2(unit="ohm")=4700"resistance";
parameter Real Re1(unit="ohm")=100"resistance";
parameter Real Rf(unit="ohm")=10000"resistance";
parameter Real hie(unit="ohm")=1100"resistance";
parameter Real Rc1(unit="ohm")=22000"resistance";
parameter Real R3(unit="ohm")=22000"resistance";
parameter Real R4(unit="ohm")=22000"resistance";
parameter Real Rs(unit="ohm")=100"resistance";
parameter Real hfe=100;
parameter Real R1(unit="ohm")=220000"Resistance";
parameter Real R2(unit="ohm")=22000"Resistance";

Real RL2(unit="ohm")"resistance";
Real Ai2;
Real Ri2(unit="ohm")"resistance";
Real Av2;
Real Ai1;
Real RL1(unit="ohm")"Resistance";
Real Ri1(unit="ohm")"Resistance";
Real Av1;
Real Av_without_gain;
Real Av;
Real Bita;
Real D;
Real Avf;
Real Rif(unit="ohm")"resistance";
Real Rif_das(unit="ohm")"resistance";
Real Ro_das(unit="ohm")"Resistance";
Real Rof_das(unit="ohm")"resistance";

equation

RL2=Rc2*(Re1+Rf)/(Rc2+Re1+Rf);
Ai2=-hfe;
Ri2=hie;
Av2=Ai2*RL2/Ri2;
Ai1=-hfe;
RL1=1/((1/Rc1)+(1/R3)+(1/R4)+(1/Ri2));
Ri1=hie+(1+hfe)*(Re1*Rf)/(Re1+Rf);
Av1=Ai1*RL1/Ri1;
Av_without_gain=Av1*Av2;
Av=Av_without_gain*Ri1/(Ri1+Rs);
Bita=Rs/(Rs+Rf);
D=1+Bita*Av;
Avf=Av/D;
Rif=Ri1*D;
Rif_das=Rif*R1*R2/(Rif*R1+R1*R2+R2*Rif);
Ro_das=RL2;
Rof_das=Ro_das/D;

// Values are varying due to round off error

end Ex3_4;