model Ex4_4

parameter Real pi=Modelica.Constants.pi;
parameter Real R(unit="ohm")=9.7*10^3"Resistance";
parameter Real f(unit="Hz")=5000"Frequency";
parameter Real gm(unit="s")=5000*10^(-6);
parameter Real rd(unit="ohm")=40*10^3"resistance";
parameter Real RL1(unit="ohm")=6.8*10^3"resistance";
parameter Real RL2(unit="ohm")=5.8*10^3"resistance";

Real C(unit="nF")"Capacitance";
Real RD1(unit="ohm")"Resistance";
Real RD2(unit="ohm")"Resistance";

equation

f=1/(2*pi*sqrt(6)*R*C*10^(-9));
RL1=RD1*rd/(RD1+rd);
RL2=RD2*rd/(RD2+rd);

// values are varying due to round off error

end Ex4_4;