package Ex9_1

model Ex9_1_1

parameter Real V1(unit="uV")=300"Voltage";
parameter Real V2(unit="uV")=240"Voltage";
parameter Real CMRR=100;
parameter Real Ad=5000"differential gain";

Real Vd(unit="uV")"differential voltage";
Real Vc(unit="V")"Voltage";
Real Ac"Gain";
Real Vo(unit="uV")"output Voltage";

equation

Vd=V1-V2;
Vc=(V1+V2)/2;
CMRR=Ad/Ac;
Vo=Ad*Vd+Ac*Vc;

end Ex9_1_1;

model Ex9_1_2

parameter Real V1(unit="uV")=300"Voltage";
parameter Real V2(unit="uV")=240"Voltage";
parameter Real CMRR=10^5;
parameter Real Ad=5000"differential gain";

Real Vd(unit="uV")"differential voltage";
Real Vc(unit="V")"Voltage";
Real Ac"Gain";
Real Vo(unit="uV")"output Voltage";

equation

Vd=V1-V2;
Vc=(V1+V2)/2;
CMRR=Ad/Ac;
Vo=Ad*Vd+Ac*Vc;

end Ex9_1_2;

end Ex9_1;