model Ex2_4

parameter Real pi=Modelica.Constants.pi;
parameter Real Rs(unit="ohm")=680"Resistance";
parameter Real R1(unit="ohm")=68000"Resistance";
parameter Real R2(unit="ohm")=22000"Resistance";
parameter Real RC(unit="ohm")=2200"Resistance";
parameter Real RL(unit="ohm")=10000"Resistance";
parameter Real hie(unit="ohm")=1100"Resistance";
parameter Real RE(unit="ohm")=1000"Resistance";
parameter Real C1(unit="F")=0.1*10^(-6)"capacitance";
parameter Real C2(unit="F")=0.1*10^(-6)"capacitance";
parameter Real CE(unit="F")=10*10^(-6)"capacitance";
parameter Real Bita=100;
Real fc_input(unit="Hz")"Frequency";
Real fc_output(unit="Hz")"Frequency";
Real fc_bypass(unit="Hz")"Frequency";
Real R_TH(unit="ohm")"Resistance";

equation

fc_input=1/(2*pi*(Rs+(R1*R2*hie)/(R1*R2+R1*hie+R2*hie))*C1);
fc_output=1/(2*pi*(RC+RL)*C2);
fc_bypass=1/(2*pi*((((R_TH+hie)/Bita)*RE)/(RE+((R_TH+hie)/Bita)))*CE);
R_TH=R1*R2*Rs/(R1*R2+R2*Rs+R1*Rs);


end Ex2_4;