model Ex4_10

parameter Real pi=Modelica.Constants.pi;
parameter Real L(unit="H")=0.4"Inductance";
parameter Real C(unit="F")=0.085*10^(-12)"Capacitance";
parameter Real CM(unit="F")=1*10^(-12)"Capacitance";
parameter Real R(unit="ohm")=5*10^3"Resistance";

Real fs(unit="Hz")"Frequency";
Real fp(unit="Hz")"Frequency";
Real Ceq(unit="pF")"equivelant Capacitance";
Real increase(unit="%");
Real Q"Q factor";

equation

fs=1/(2*pi*sqrt(L*C));
Ceq=C*CM/(C+CM);
fp=1/(2*pi*sqrt(L*Ceq));
increase=((fp-fs)/fs)*100;
Q=2*pi*fs*L/R;

// Values are varying due to round off error

end Ex4_10;