model Ex4_23

parameter Real pi=Modelica.Constants.pi;
parameter Real L(unit="H")=0.33"inductance";
parameter Real C(unit="F")=0.065*10^(-12)"Capacitance";
parameter Real CM(unit="F")=1*10^(-12)"Capacitance";
parameter Real R(unit="ohm")=5.5*10^3"Resistance";

Real Ceq(unit="F")"equivelent capacitance";
Real fs(unit="Hz")"Frequency";
Real fp(unit="Hz")"Frequency";
Real increase(unit="%")"% increase";
Real Q; 

equation

fs=1/(2*pi*sqrt(L*C));
Ceq=C*CM/(C+CM);
fp=1/(2*pi*sqrt(L*Ceq));
increase=((fp-fs)/fs)*100;
Q=2*pi*fs*L/R;

end Ex4_23;