model Ex2_5

parameter Real pi=Modelica.Constants.pi;
parameter Real R_G(unit="ohm")=100*10^6"Resistance";
parameter Real V_GS(unit="V")=8"Voltage";
parameter Real I_GSS(unit="A")=80*10^(-9)"current";
parameter Real C1(unit="F")=0.001*10^(-6)"Capacitance";
parameter Real C2(unit="F")=10^(-6)"Capacitance";
parameter Real R_D(unit="Mohm")=2200"Resistance";
parameter Real R_L(unit="Mohm")=22000"Resistance"; 

Real Rin(unit="ohm")"resistance";
Real fc_input(unit="Hz")"input frequency";
Real fc_output(unit="Hz")"output frequency";

equation

Rin=R_G*(V_GS/I_GSS)/(R_G+(V_GS/I_GSS));
fc_input=1/(2*pi*Rin*C1);
fc_output=1/(2*pi*(R_D+R_L)*C2);

end Ex2_5;