model Ex2_7

parameter Real gm(unit="ms")=6;
parameter Real RD(unit="ohm")=2200"Resistance";
parameter Real RL(unit="ohm")=22000"Resistance";
parameter Real RG(unit="ohm")=2200"Resistance";
parameter Real Rs(unit="ohm")=100"Resistance";
parameter Real Crss(unit="F")=2*10^(-12)"capacitance";
parameter Real Ciss(unit="F")=6*10^(-12)"capacitance";
parameter Real pi=Modelica.Constants.pi;

Real Av"Gain";
Real Cin(unit="F")"capacitance";
Real Cout(unit="F")"capacitance";
Real Cgs(unit="F")"capacitance";
Real fc_input(unit="Hz")"capacitance";
Real fc_output(unit="Hz")"capacitance";

equation

Av=-gm*(RD*RL/(RD+RL))*10^(-3);
Cin=Crss*(-Av+1);
Cout=Crss*(-Av+1)/(-Av);
Cgs=Ciss-Crss;
fc_input=1/(2*pi*Rs*(Cgs+Cin));
fc_output=1/(2*pi*(RD*RL/(RD+RL))*Cout);

end Ex2_7;