model Ex3_8

parameter Real rd(unit="ohm")=8000"resistance";
parameter Real gm(unit="mA/V")=5;
parameter Real Rg(unit="ohm")=1*10^6"resistance";
parameter Real R1(unit="ohm")=50"resistance";
parameter Real Rd(unit="ohm")=40*10^3"resistance";

Real Av"Voltage gain";
Real Av_mid"Voltage gain";
Real Req(unit="ohm")"equivalent resistance";
Real Bita;
Real R2(unit="ohm")"resistance";
Real D;
Real Avf"Voltage gain with feedback";

equation

Rg=R1+R2;
Av_mid=-gm*10^(-3)*Req;
Req=Rd*rd*Rg/(Rd*rd+rd*Rg+Rd*Rg);
Av=Av_mid^3;
Bita=-R1/(R1+R2);
D=1+Bita*Av;
Avf=Av/D;

// there is round off error

end Ex3_8;