model Ex3_9

parameter Real rd(unit="ohm")=8000"resistance";
parameter Real gm(unit="mA/V")=5;
parameter Real Rg(unit="ohm")=1*10^6"resistance";
parameter Real R1(unit="ohm")=50"resistance";
parameter Real Rd(unit="ohm")=40*10^3"resistance";

Real Av_mid"Voltage gain";
Real Req(unit="ohm")"equivalent resistance";
Real R2(unit="ohm")"resistance";
Real Av2;
Real Av3;
Real Av0;
Real A_BN;
Real Bita_BN;
Real Bita_A;
Real Avf"Voltage Gain with feedback";

equation

Rg=R1+R2;
Av_mid=-gm*10^(-3)*Req;
Req=Rd*rd*Rg/(Rd*rd+rd*Rg+Rd*Rg);
Av2=Av_mid;
Av3=Av_mid;
Av0=Av_mid;
A_BN=Av_mid;
Bita_A=Bita_BN*A_BN;
Bita_BN=-(R1/Rg)*Av2*Av3;
Avf=A_BN/(1+Bita_BN*A_BN);

end Ex3_9;