model Ex4_26

parameter Real pi=Modelica.Constants.pi;
parameter Real L1(unit="H")=20*10^(-6)"inductance";
parameter Real L2(unit="H")=2*10^(-3)"inductance";
parameter Real f_max(unit="Hz")=2.5*10^6"Frequency";
parameter Real f_min(unit="Hz")=1*10^6"Frequency";

Real C1(unit="F")"Capacitance for maximum Frequency";
Real C2(unit="F")"Capacitance for minimum Frequency";
Real Leq(unit="H")"equivelant inductance";

equation

Leq=L1+L2;
f_max=1/(2*pi*sqrt(C1*Leq));
f_min=1/(2*pi*sqrt(C2*Leq));


end Ex4_26;