model Ex9_13

parameter Real R1(unit="kohm")=86"Resistance";
parameter Real R2(unit="kohm")=100"Resistance";
parameter Real Rf(unit="ohm")=100*10^3"Resistance";
parameter Real Vsat(unit="V")=15"Voltage";
parameter Real C(unit="F")=0.1*10^(-6)"Capacitance";

Real V_UT(unit="V")"voltage";
Real V_LT(unit="V")"Voltage";
Real fo(unit="Hz")"Frequency";

equation

V_UT=R1*Vsat/(R1+R2);
V_LT=-R1*Vsat/(R1+R2);
fo=1/(2*Rf*C*log((Vsat-V_LT)/(Vsat-V_UT)));

end Ex9_13;