model Ex10_1

parameter Real ZZ(unit="ohm")=7"impedance";
parameter Real R3(unit="ohm")=330"Resistance";
parameter Real Vo(unit="V")=4.7"output Voltage";
parameter Real Vin(unit="V")=15"input Voltage";
parameter Real IL(unit="mA")=50*10^(-3)"Current";
parameter Real Rs(unit="ohm")=20"Resistance";

Real delta_Vin(unit="V")"Voltage";
Real delta_Vo(unit="V")"Voltage";
Real L(unit="%")"Line regulation";
Real delta_Vo1(unit="V")"Voltage";
Real L1(unit="%")"Load regulation";
Real VRout_VRin"VRout/VRin";
Real RR(unit="dB");

equation

delta_Vin=10*Vin/100;
delta_Vo=delta_Vin*ZZ/R3;
L=delta_Vo*100/Vo;
delta_Vo1=IL*Rs*ZZ/R3;
L1=delta_Vo1*100/Vo;
VRout_VRin=ZZ/R3;
RR=20*log10(VRout_VRin);


end Ex10_1;