model Ex3_10

parameter Real u=50;
parameter Real rd(unit="ohm")=10*10^3"resistance";
parameter Real RD(unit="ohm")=22*10^3"resistance";
parameter Real RG2(unit="ohm")=1*10^6"resistance";
parameter Real Rs(unit="ohm")=330"resistance";
parameter Real Rf(unit="ohm")=1*10^4"resistance";
parameter Real RG(unit="ohm")=1*10^6"resistance";
parameter Real R1(unit="ohm")=10*10^3"resistance";
parameter Real R2(unit="ohm")=300"resistance";
parameter Real R3(unit="ohm")=22*10^3"resistance";

Real Av"Voltage gain";
Real Av1"Voltage gain";
Real Av2"Voltage gain";
Real R_L2(unit="ohm")"resistance";
Real R_Deff(unit="ohm")"resistance";
Real R_seff(unit="ohm")"resistance";
Real Bita;
Real D;
Real Avf"Voltage gain with feedback";
Real Ri(unit="ohm")"resistance";
Real Rif(unit="ohm")"resistance";
Real Ro_das(unit="ohm")"resistance";
Real Rof_das(unit="ohm")"resistance";

equation

Av=Av1*Av2;
Av2=-u*R_L2/(R_L2+rd);
R_L2=(R1+R2)*R3/(R1+R2+R3);
R_Deff=RD*RG2/(RD+RG2);
Av1=-u*R_Deff/(rd+R_Deff+(1+u)*R_seff);
R_seff=Rs*R1/(Rs+R1);
Bita=Rs/(Rs+Rf);
D=1+Bita*Av;
Avf=Av/D;
Ri=RG;
Rif=Ri*D;
Ro_das=rd*R_L2/(rd+R_L2);
Rof_das=Ro_das/D;

// Values are may be vary due to round off error

end Ex3_10;