model Ex3_12

parameter Real hfe=50;
parameter Real Rc1(unit="ohm")=2*10^3"resistance";
parameter Real Re2(unit="ohm")=500"resistance";
parameter Real R_das(unit="ohm")=5*10^3"resistance";
parameter Real hie(unit="ohm")=1.5*10^3"resistance";
parameter Real Rs(unit="ohm")=1*10^3"resistance";
parameter Real Re1(unit="ohm")=300"resistance";

Real AI"current Gain";
Real Ai1;
Real Ai2;
Real Ic2_Ib2"=Ic2/Ib2";
Real Ic1_Ib1"=Ic1/Ib1";
Real Ib2_Ic1"=Ib2/Ic1";
Real Ib1_Is"=Ib1/Is";
Real Ri2(unit="ohm")"Resistance";
Real R(unit="ohm")"Resistance";
Real Ri1(unit="ohm")"Resistance";
Real Bita;
Real D;
Real A_If;

equation

AI=-Ic2_Ib2*Ic1_Ib1*Ib2_Ic1*Ib1_Is;
Ai2=-hfe;
Ai1=-hfe;
Ic2_Ib2=Ai2;
Ic1_Ib1=Ai1;
Ib2_Ic1=-Rc1/(Rc1+Ri2);
Ri2=hie+(1+hfe)*(Re2*R_das/(Re2+R_das));
Ib1_Is=R/(R+Ri1);
R=Rs*(R_das+Re2)/(Rs+R_das+Re2);
Ri1=hie+(1+hfe)*Re1;
Bita=Re2/(Re2+R_das);
D=1+Bita*AI;
A_If=AI/D;

end Ex3_12;