model Ex3_13

parameter Real Rc2(unit="ohm")=4700"resistance";
parameter Real R1(unit="ohm")=150"resistance";
parameter Real hie(unit="ohm")=1100"resistance";
parameter Real Rc1(unit="ohm")=10000"resistance";
parameter Real R3(unit="ohm")=47000"resistance";
parameter Real R4(unit="ohm")=33000"resistance";
parameter Real R2(unit="ohm")=15000"resistance";
parameter Real hfe=500;
parameter Real hre=0; 

Real RL2(unit="ohm")"resistance";
Real hoe;
Real Ai2;
Real Ri2(unit="ohm")"resistance";
Real Av2;
Real Ai1;
Real RL1(unit="ohm")"Resistance";
Real Ri1(unit="ohm")"Resistance";
Real Av1;
Real Av;
Real Bita;
Real D;
Real Avf;
Real Rif(unit="ohm")"resistance";
Real Ro(unit="ohm")"Resistance";
Real Rof(unit="ohm")"resistance";

equation

RL2=Rc2*(R1+R2)/(Rc2+R1+R2);
hoe=hre;
Ai2=-hfe;
Ri2=hie;
Av2=Ai2*RL2/Ri2;
Ai1=-hfe;
RL1=1/((1/Rc1)+(1/R3)+(1/R4)+(1/Ri2));
Ri1=hie+(1+hfe)*(R1*R2)/(R1+R2);
Av1=Ai1*RL1/Ri1;
Av=Av1*Av2;
Bita=R1/(R1+R2);
D=1+Bita*Av;
Avf=Av/D;
Rif=Ri1*D;
Ro=RL2;
Rof=Ro/D;

// Values may be vary due to round off error

end Ex3_13;