model Ex3_16

parameter Real hie(unit="ohm")=1000;
parameter Real hfe=50;
parameter Real hre=0;
parameter Real hoe=0;
parameter Real Rs(unit="ohm")=1000"Resistance";
parameter Real Rb(unit="ohm")=4272"Resistance";
parameter Real R1(unit="ohm")=47000"Resistance";
parameter Real R2(unit="ohm")=4700"Resistance";
parameter Real Rc(unit="ohm")=1800"Resistance";
parameter Real Re(unit="ohm")=1000"Resistance";
parameter Real RL(unit="ohm")=1800"Resistance";

Real Avf;
Real Rs_das(unit="ohm")"Resistance";
Real G_Mf;
Real Bita;
Real GM;
Real D;
Real Ri(unit="ohm")"Resistance";
Real Rif(unit="ohm")"Resistance";
Real Rof_das(unit="ohm")"Resistance";
Real RD(unit="ohm")"resistance";

equation

Avf=-hfe*Rc*(1/(1+Rs/Rb))/(Rs_das+hie+(1+hfe)*Re);
Rs_das=Rs*R1*R2/(Rs*R1+R1*R2+R2*Rs);
G_Mf=Avf/RL;
Bita=-Re;
G_Mf=GM/(1+Bita*GM);
D=1+Bita*GM;
Ri=Rs+(hie+Re)*RD/(hie+Re+RD);
RD=R1*R2/(R1+R2);
Rif=Ri*D;
Rof_das=RL;

// Values are varying due to round off error

end Ex3_16;