model Ex9_4

parameter Real V_UT(unit="V")=4"Voltage";
parameter Real V_LT(unit="V")=-4"Voltage";
parameter Real Supply(unit="V")=15"Voltage";
parameter Real IB_max(unit="nA")=500"Current";
parameter Real R2_1(unit="Ohm")=82*10^3"Resistance";

Real Vo(unit="V")"Voltage";
Real I2(unit="uA")"Current";
Real R2(unit="kohm")"resistance";
Real I2_1(unit="uA")"Current";
Real R1(unit="kohm")"Resistance";

equation

Vo=0.9*Supply;
I2=100*IB_max/10^3;
R2=V_UT*1000/I2;
I2_1=V_UT*10^6/R2_1;
R1=(Vo-V_UT)*10^3/I2_1;


end Ex9_4;