model Ex8_1

parameter Real l(unit="cm")=1"length";
parameter Real d(unit="m^2")=0.1"";
parameter Real un(unit="cm^2/V*s")=1500;
parameter Real q(unit="C")=1.6*10^(-19)"Charge";
parameter Real n(unit="cm^(-3)")=5*10^16"concentration";
parameter Real pi=Modelica.Constants.pi;

Real sigma(unit="1/ohm.cm")"sigma";
Real R(unit="ohm")"resistance";
Real S(unit="cm^2")"area";

equation

S=pi*(d/2)^2;
sigma=n*q*un;
R=(1/sigma)*(l/S);

end Ex8_1;