model Ex7_1

parameter Real R(unit="kohm")=1"resistance";
parameter Real C(unit="nF")=100"capacitance";
parameter Real L(unit="mH")=50"inductance";
parameter Real Vs(unit="V")=12"voltage";

Real wr(unit="rad/sec")"angular frequency";
Real Q_def"quality factor";
Real VL_r(unit="V")"Voltage";
Real VC_r(unit="V")"Voltage";

equation

wr=sqrt(1/(L*C*10^(-12)));
Q_def=10^(-6)*wr*L/R;
VL_r=Q_def*Vs;
VC_r=VL_r;

end Ex7_1;