model Ex8_5

parameter Real V_th(unit="V")=1.5"voltage";
parameter Real V_DD(unit="V")=12"voltage";
parameter Real V_GS1(unit="V")=0.5"voltage";
parameter Real V_GS2(unit="V")=5"voltage";
parameter Real Kn(unit="mA/V^2")=0.1;
parameter Real RD(unit="kohm")=2.2"";


Real ID1(unit="mA")"current";
Real ID2(unit="mA")"current";
Real vo1(unit="V")"output voltage at VGS=0.5";
Real vo2(unit="V")"output voltage at VGS=5";


equation

ID1=Kn*(V_GS1-V_th)^2;
ID2=Kn*(V_GS2-V_th)^2;
vo1=V_DD-RD*ID1;
vo2=V_DD-RD*ID2;

end Ex8_5;