model Ex9_7

parameter Real VsM(unit="V")=30"Voltage";
parameter Real Ron(unit="ohm")=10"Resistance";
parameter Real RL(unit="ohm")=1000"Resistance";
parameter Real pi=Modelica.Constants.pi;

Real IM(unit="mA")"Current";
Real Io_DC(unit="mA")"Current";
Real Io_RMS(unit="mA")"Current";
Real Vo_DC(unit="V")"Voltage";
Real Vo_RMS(unit="V")"Voltage";
Real Po_DC(unit="W")"Power";
Real Pi(unit="W")"Power";

equation

IM=(VsM/(RL+Ron))*1000;
Io_DC=((2*VsM/pi)/(Ron+RL))*1000;
Io_RMS=20.8;
Vo_DC=Io_DC*10^(-3)*RL;
Vo_RMS=Io_RMS*10^(-3)*RL;
Po_DC=Io_DC*Vo_DC*10^(-3);
Pi=Io_RMS*Vo_RMS*10^(-3);

// Values are varying due to round off error
end Ex9_7;