model Ex4_8

parameter Real R1(unit="kohm")=12"resistance";
parameter Real R2(unit="kohm")=4.7"resistance";
parameter Real R3(unit="kohm")=10"resistance";
parameter Real R4(unit="kohm")=6"resistance";
parameter Real R5(unit="kohm")=1"resistance";
parameter Real ig(unit="mA")=5"current";

Real R45(unit="kohm")"resistance";
Real R345(unit="kohm")"resistance";
Real R2345(unit="kohm")"resistance";
Real R12345(unit="kohm")"resistance";
Real vg(unit="V")"Voltage";
Real Pg(unit="w")"Power";
Real iR1(unit="mA")"current";
Real iR2345(unit="mA")"current";
Real vR3(unit="V")"voltage";
Real iR45(unit="mA")"current";
Real vR5(unit="V")"voltage";
Real PR5(unit="mW")"power";

equation

R45=R4+R5;
R345=R3*R45/(R3+R45);
R2345=R2+R345;
R12345=R1*R2345/(R1+R2345);
vg=R12345*ig;
Pg=vg*ig/1000;
iR1=vg/R1;
iR2345=ig-iR1;
vR3=vg-R2*iR2345;
iR45=vR3/R45;
vR5=R5*iR45;
PR5=vR5*iR45;


end Ex4_8;