model Ex9_2

parameter Real V_M(unit="V")=10"voltage";
parameter Real R(unit="ohm")=500"resistance";
parameter Real pi=Modelica.Constants.pi;

Real IM(unit="mA")"current";
Real I_DC(unit="mA")"current";
Real I_RMS(unit="mA")"current";
Real V_DC(unit="V")"Voltage";
Real Po_DC(unit="W")"power";
Real Ps(unit="mW")"power";
Real P_DC(unit="mW")"power";
Real gamma;

equation

IM=V_M*1000/R;
I_DC=V_M*1000/(pi*R);
I_RMS=IM/2;
V_DC=2*V_M/pi;
Po_DC=2*IM*V_M/1000;
Ps=I_RMS*V_M;
P_DC=I_DC*V_DC;
gamma=1.23;

// Value of Po_DC is wrong in the textbook
// there is round off error

end Ex9_2;