model Ex6_4

parameter Real VB(unit="V")=20"voltage";
parameter Real R1(unit="ohm")=1000"resistance";
parameter Real R2(unit="ohm")=2700"resistance";

Real V_TH(unit="V")"voltage";
Real P_L(unit="mW")"power";
Real VL(unit="V")"voltage";
Real IL(unit="A")"current";
Real RTH(unit="ohm")"resistance";
Real RL(unit="ohm")"resistance";

equation

V_TH=R2*VB/(R1+R2);
RTH=R1*R2/(R1+R2);
RL=RTH;
VL=V_TH/2;
IL=V_TH/(2*RTH);
P_L=VL*IL*1000;

end Ex6_4;