model Ex3_20_4

parameter Real I(unit="A")=2"Current";
parameter Real r(unit="m")=1"distance";
parameter Real f(unit="Hz")=300"frequency";
parameter Real A(unit="m^2")=0.1"area";
parameter Real pi=Modelica.Constants.pi;
parameter Real mue_0=Modelica.Constants.mue_0;

Real H_rms(unit="A/m")"rms value of H field";
Real H_peak(unit="A/m")"peak value of H field";
Real B(unit="T")"B field";
Real V(unit="V")"peak induced voltage";

equation

H_rms=I/(2*pi*r);
H_peak=H_rms*sqrt(2);
B=mue_0*H_peak;
V=2*pi*f*A*B;

end Ex3_20_4;