model Ex3_3_3

parameter Real C(unit="F")=1*10^(-6)"Capacitance";
parameter Real f1(unit="Hz")=100"Frequency";
parameter Real f2(unit="Hz")=1000"Frequency";
parameter Real f3(unit="Hz")=10000"Frequency";
parameter Real pi=Modelica.Constants.pi;
parameter Real R(unit="ohm")=159"Resistance";

Real Xc1(unit="ohm")"reactance for 100Hz frequency";
Real Xc2(unit="ohm")"reactance for 1kHz frequency";
Real Xc3(unit="ohm")"reactance for 10kHz frequency";
Real Z1(unit="ohm")"impedance for 100Hz frequency";
Real Z2(unit="ohm")"impedance for 1kHz frequency";
Real Z3(unit="ohm")"impedance for 10kHz frequency";

equation

Xc1=1/(2*pi*f1*C);
Xc2=1/(2*pi*f2*C);
Xc3=1/(2*pi*f3*C);
Z1=sqrt(R^2+Xc1^2);
Z2=sqrt(R^2+Xc2^2);
Z3=sqrt(R^2+Xc3^2);

// Values are not matching due to round off

end Ex3_3_3;