model Ex3_3_5

parameter Real R(unit="ohm")=5000"resistance";
parameter Real C(unit="F")=0.02*10^(-6)"capacitance";
parameter Real V(unit="V")=10"voltage";
parameter Real f(unit="Hz")=1000"frequency";
parameter Real pi=Modelica.Constants.pi;
Real IR(unit="A")"Peak Current in resistor";
Real IC(unit="A")"Peak current in capacitor";
Real I(unit="A")"Total current";
Real Z(unit="ohm")"impedance";
Real Xc(unit="ohm")"Reactance";

equation

IR=V/R;
Xc=1/(2*pi*f*C);
IC=V/Xc;
I=sqrt(IC^2+IR^2);
Z=V/I;

// Values are not matching with the textbook due to round off

end Ex3_3_5;