model Ex4_23_3

parameter Real d1(unit="cm")=2"distance";
parameter Real d2(unit="cm")=3"distance";
parameter Real d3(unit="cm")=4"distance";
parameter Real d(unit="cm")=0.5"distance";
parameter Real c(unit="cm/s")=3*10^10"light speed";
parameter Real F(unit="Hz")=10*10^6"frequency";
parameter Real E(unit="V/m")=2"external field strength";

Real lembda(unit="cm")"Half-wavelength";
Real A1"attenuation";
Real A2"attenuation";
Real A3"attenuation";
Real A"wire screen attenuation";
Real E1(unit="V/m")"E field";
Real E2(unit="V/m")"E field";
Real E3(unit="V/m")"E field";
Real E4(unit="V/m")"Sum of E field";
Real E5(unit="V/m")"E field";

equation

lembda=(c/F)/2;
A=d/lembda;
A1=d1/lembda;
A2=d2/lembda;
A3=d3/lembda;
E1=A1*E;
E2=A2*E;
E3=A3*E;
E4=E1+E2+E3;
E5=A*E;



end Ex4_23_3;