model Ex6_15_2

parameter Real T(unit="us")=0.01"Rise Time";
parameter Real V(unit="V")=10"Voltage";
parameter Real I(unit="A")=20*10^(-3)"current";
parameter Real A(unit="cm^2")=57"area";
parameter Real d(unit="m")=3.33"Distance";
parameter Real F1(unit="Hz")=9.9"Frequency";
parameter Real pi=Modelica.Constants.pi;
parameter Real E1(unit="uV/m")=316"Radiation";
parameter Real R1(unit="ohm")=0.6"Impedance";

Real E(unit="uV/m")"Radiation level";
Real F(unit="MHz")"Frequency";

equation

E=E1*A*R1*V/(F1*d);
F=1/(pi*T);

end Ex6_15_2;