model Ex4_23_4

parameter Real d1(unit="m")=0.2"distance";
parameter Real d2(unit="m")=10"distance";
parameter Real c(unit="m/s")=3*10^8"light speed";
parameter Real F1(unit="Hz")=10*10^6"frequency";
parameter Real F2(unit="Hz")=1*10^6"frequency";
parameter Real F3(unit="Hz")=100*10^6"frequency";
parameter Real E(unit="V/m")=20"external field strength";

Real lembda1(unit="cm")"Half-wavelength at 10 MHz";
Real lembda2(unit="cm")"Half-wavelength at 1 MHz";
Real lembda3(unit="cm")"Half-wavelength at 100 MHz";
Real A1"attenuation at 10 MHz";
Real A2"attenuation at 1 MHz";
Real A3"attenuation at 100 MHz";
Real V1(unit="V")"Voltage at 10 MHz";
Real V2(unit="V")"Voltage at 1 MHz";
Real V3(unit="V")"Voltage at 100 MHz";

equation

lembda1=(c/F1)/2;
lembda2=(c/F2)/2;
lembda3=(c/F3)/2;
A1=d2/lembda1;
A2=d2/lembda2;
A3=d2/lembda3;
V1=A1*2*d1*E;
V2=A2*2*d1*E;
V3=A3*2*d1*E;

// given result in the textbook is wrong

end Ex4_23_4;