model Ex5_17_2

parameter Real T(unit="us")=0.2"Rise Time";
parameter Real V(unit="V")=20"Voltage";
parameter Real I(unit="mA")=100*10^(-3)"current";
parameter Real A(unit="cm^2")=3"area";
parameter Real d(unit="m")=3"Distance";
parameter Real F1(unit="Hz")=1000"Frequency";
parameter Real pi=Modelica.Constants.pi;
parameter Real E1(unit="uV/m")=316"Radiation";
parameter Real R1(unit="ohm")=200/30"Impedance";

Real R(unit="ohm")"Impedance";
Real E(unit="uV/m")"Radiation level";
Real F(unit="MHz")"Frequency";

equation

R=V/I;
F=2/(pi*T);
E=(E1*A*V)/(R1*F1);

end Ex5_17_2;