model Ex3_3_4

parameter Real L(unit="H")=1"Inductance";
parameter Real f1(unit="Hz")=100"Frequency";
parameter Real f2(unit="Hz")=1000"Frequency";
parameter Real f3(unit="Hz")=10000"Frequency";
parameter Real pi=Modelica.Constants.pi;
parameter Real R(unit="ohm")=6280"resistance";

Real Xl1(unit="ohm")"reactance for 100Hz frequency";
Real Xl2(unit="ohm")"reactance for 1kHz frequency";
Real Xl3(unit="ohm")"reactance for 10kHz frequency";
Real Z1(unit="ohm")"impedance for 100Hz frequency";
Real Z2(unit="ohm")"impedance for 1kHz frequency";
Real Z3(unit="ohm")"impedance for 10kHz frequency";

equation

Xl1=(2*pi*f1*L);
Xl2=(2*pi*f2*L);
Xl3=(2*pi*f3*L);
Z1=sqrt(R^2+Xl1^2);
Z2=sqrt(R^2+Xl2^2);
Z3=sqrt(R^2+Xl3^2);

// Values are not matching due to round off

end Ex3_3_4;