//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-10: Approximate Solutions of the Navier-Stokes Equation
//Example 10.2 Page 527
//Title: Terminal Velocity of a Particle from a Volcano

model Ex10_2

//=================
//Parameter Section
parameter Real D(unit = "mu.m") = 50 "Diameter of the sperical ash particle";
parameter Real Rho_p(unit = "kg/m3") = 1240 "Density of the particle";
parameter Real g(unit = "m/s2") = 9.81 "Gravitational constant";

//Property estimated at -50 C and atmospheric pressure
parameter Real mu(unit = "kg/m.s") = 1.474*0.00001 "Viscosity" ;

//Property estimated at -50 C and 55 kPa
parameter Real Rho_a(unit = "kg/m3") = 0.8588 "Density of air";

//=================
//Variable Section 
Real V(unit = "m/s") "Terminal velocity of the particle";
Real Re(unit = "-") "Reynolds number";
String Flow;

//=================
//Equation Section
equation 
/*From equating the net upward force (aerodynamic drag + buoyancy)
and net downward force (weight)*/
V = (((D*0.000001)^2)/(18*mu))*(Rho_p-Rho_a)*g;

/*Verification if Reynolds number is small enough that creeping flow is
an appropriate approximation*/
Re = (Rho_a*V*D*0.000001)/mu;
//Multiplying D by 0.000001 to convert mu.m to m

if Re<1
then
Flow = "Creeping flow";
else
Flow = "Not a creeping flow";
end if;

Modelica.Utilities.Streams.print(Flow);

end Ex10_2;
//=================
