//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-10: Approximate Solutions of the Navier-Stokes Equation
//Example 10.6 Page 547
//Title: Velocity in a Flow Composed of Three Components

model Ex10_6
extends Modelica.Constants;

//=================
//Parameter Section
parameter Real tow(unit = "m2/s") = 1.5 "Line vortex of strength";
parameter Real Ratio_1(unit = "m2/s") = 2 "Line source of strength";//Ratio-1 = (v/L)1
parameter Real Ratio_2(unit = "m2/s") = -1 "Line source of strength"; //Ratio-2 = (v/L)2

//From Figure 10-52, Page.547

//Since the vortex is located 1 m above the point (1,0)
parameter Real r_vortex(unit = "m") = 1 "Magnitude of vortex";

//Since the first source induces a velocity at point (1,0) at a 45° angle from the x-axis 
parameter Real r_source_1(unit = "m") = sqrt(2) "Magnitude of source_1"; 

//Since the second source (the sink) induces a velocity straight down with magnitude
parameter Real r_source_2(unit = "m") = 1 "Magnitude of source_2";

//=================
//Variable Section 
Real V_vortex(unit = "m/s") "Velocity at the vortex";
Real V_source_1(unit = "m/s") "Velocity at the source-1";
Real V_source_2(unit = "m/s") "Velocity at the source-2";

//=================
//Equation Section
equation 
V_vortex = tow/(2*pi*r_vortex);
V_source_1 = (Ratio_1)/(2*pi*r_source_1);
V_source_2 = -(Ratio_2)/(2*pi*r_source_2);

//Final Answer in vector form; V = V_vortex + V_source_1 + V_source_2

end Ex10_6;
//=================
