//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-12: Compressible Flow  
//Example 12.10  Page 699
//Title: Oblique Shock Calculations

model Ex12_10

extends Modelica.Math;
extends Modelica.Constants;

//=================
//Parameter Section
parameter Real Ma_1(unit = "-") = 2 "Mach number of supersonic air"; 
parameter Real P(unit = "kPa") = 75.0 "Pressure of supersonic air";
parameter Real k(unit = "-") = 1.4 "Specific heat ratio";
parameter Real delta(unit = "degree") = 10 "2D-Wedge half angle";
parameter Real theta(unit = "degree") = 10 "2D-Wedge half angle";

//Two possible values with the given angle
parameter Real beta_W(unit = "degree") = 39.3 "Oblique shock angle";
parameter Real beta_S(unit = "degree") = 83.7 "Oblique shock angle";
                 
//=================
//Variable Section 
Real Ma_1nW(unit = "-") "Upstream normal Mach number for weak shock";
Real Ma_1nS(unit = "-") "Upstream normal Mach number for strong shock";
Real Ma_2nW(unit = "-") "Downstream normal Mach number for weak shock";
Real Ma_2nS(unit = "-") "Downstream normal Mach number for strong shock";
Real P2_W(unit = "kPa") "Downstream pressure for weak shock";
Real P2_S(unit = "kPa") "Downstream pressure for strong shock";
Real Ma_2W(unit = "-") "Downstream Mach Number for weak shock";
Real Ma_2S(unit = "-") "Downstream Mach Number for strong shock";

//=================
//Equation Section 
equation 
Ma_1nW = Ma_1*sin(beta_W*(pi/180));
Ma_1nS = Ma_1*sin(beta_S*(pi/180));
//Multiplying by (pi/180) to convert deg to rad

Ma_2nW = sqrt((((k-1)*(Ma_1nW^2))+2)/(2*k*(Ma_1nW^2)-k+1));
Ma_2nS = sqrt((((k-1)*(Ma_1nS^2))+2)/(2*k*(Ma_1nS^2)-k+1));
P2_W = (P*(((2*k*(Ma_1nW^2))-k+1)/(k+1)));
P2_S = (P*(((2*k*(Ma_1nS^2))-k+1)/(k+1)));


Ma_2W = Ma_2nW/(sin(beta_W*(pi/180))-(theta*(pi/180)));
Ma_2S = Ma_2nS/(sin(beta_S*(pi/180))-(theta*(pi/180)));
//Multiplying by (pi/180) to convert deg to rad

//The answer may slightly vary due to rounding off values

end Ex12_10;
//==================
