//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-12: Compressible Flow  
//Example 12.11  Page 700
//Title: Prandtl–Meyer Expansion Wave Calculations

model Ex12_11
extends Modelica.Math;
extends Modelica.Constants;

//=================
//Parameter Section
parameter Real Ma_1(unit = "-") = 2 "Upstream Mach number of supersonic air"; 
parameter Real P1(unit = "kPa") = 230 "Upstream Pressure of supersonic air";
parameter Real k(unit = "-") = 1.4 "Specific heat ratio";
parameter Real delta(unit = "degree") = 10 "Wall expansion angle";
                 
//=================
//Variable Section 
Real v_Ma1(unit = "degree") "Upstream Prandtl–Meyer function";
Real v_Ma2(unit = "degree") "Downstream Prandtl–Meyer function";
Real P2(unit = "kPa") "Downstream pressure";
Real theta(unit = "degree") "Total deflection angle";
Real Ma_2(unit = "-") "Downstream Mach number";

//=================
//Equation Section 
equation 
v_Ma1 = (((sqrt((k+1)/(k-1)))*(atan(sqrt(((k-1)/(k+1))*((Ma_1^2)-1))))-(atan(sqrt((Ma_1^2)-1)))))/pi*180;
//Multiplying by (pi/180) to convert degree to radian

theta = (delta);
v_Ma2 = v_Ma1+theta;

(v_Ma2/180)*pi = (((sqrt((k+1)/(k-1)))*(atan(sqrt(((k-1)/(k+1))*((Ma_2^2)-1))))-(atan(sqrt((Ma_2^2)-1)))));
//Multiplying by (180/pi) to convert radian to degree

P2 = (((1+((k-1)/2)*(Ma_2^2))^((-k)/(k-1)))/((1+((k-1)/2)*(Ma_1^2))^((-k)/(k-1))))*P1;

end Ex12_11;

//==================
