//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-13: Open-Channel Flow
//Example 13.6 Page 762
//Title: Gradually Varied Flow with M1 Surface Profile

package Ex13_6
model Ex13_6_a

//=================
//Parameter Section
parameter Real v(unit = "m3/s.m") = 1 "Flow rate of water per unit width";
parameter Real S0(unit = "-") = 0.001 "Bottom  slope";
parameter Real n(unit = "-") = 0.02 "Manning coefficient";
parameter Real a(unit = "m^(1/3)/s") = 1 "Dimensional constant";
parameter Real g(unit = "m/s2") = 9.81 "Gravitational constant";
parameter Real y(unit = "m") = 0.8 "Depth of flow";

//=================
//Variable Section 
Real y_n(unit = "m") "Normal Depth of flow";
Real y_c(unit = "m") "Critical depth of flow";
String Profile;

//=================
//Equation Section 
equation 
y_n = ((v*n)/(a^0.33*S0^0.5))^(3/5);
y_c = ((v^2)/g)^(1/3);


//Profile Classification
if y_c < y_n and y_n < y then
Profile = "M1";
else 
Profile = "Not M1";
end if;

Modelica.Utilities.Streams.print(Profile);  

end Ex13_6_a;
//==================
model Ex13_6_b

//=================
//Parameter Section
//Input-Flow depths for different x values
parameter Real [11] x_array(each unit = "m") = {0,100,200,300,400,500,600,700,800,900,1000}"Distance along the channel";

//=================
//Variable Section 
Real [11] y_array(each unit = "m") "Water depth";

//=================
//Equation Section 

equation 
//Second-Order Polynomial equation obtained upon intergration
//To generate a plot x vs y - surface profile

for i in 1:11 loop
y_array[i] = 0.7930 + 0.0002789*x_array[i] + 3.7727*0.0000001*x_array[i]^2;
end for;

end Ex13_6_b;

//==================

end Ex13_6;

//==================
