//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-14: Turbomachinery
//Example 14.13 Page 851
//Title: Hydroturbine Design

package Ex14_13
model Ex14_13_a
extends Modelica.Constants;

//=================
//Parameter Section
parameter Real r_1(unit = "m") = 1.77 "Outlet radius";
parameter Real r_2(unit = "m") = 2.5 "Inlet radius";
parameter Real b_1(unit = "m") = 2.62 "Outlet-runner blade width";
parameter Real b_2(unit = "m") = 0.914 "Inlet-runner blade width";
parameter Real omega(unit = "rad/s") = 12.57 "Rotational speed";
parameter Real Rho_w(unit = "kg/m3") = 998 "Density of water at 20 C";
parameter Real alpha_2a(unit = "degree") = 33 "Angle in the wicket gate";
parameter Real alpha_1a(unit = "degree") = 10 "Angle in the wicket gate";
parameter Real v(unit = "m3/s") = 599 "Volume flow rate of water";
parameter Real g(unit = "m/s2") = 9.81 "Gravitational constant";

//=================
//Variable Section 
Real V2_na(unit = "m/s") "Normal velocity component at the inlet";
Real V2_ta(unit = "m/s") "Tangential velocity at the inlet";
Real V1_na(unit = "m/s") "Normal velocity component at the outlet";
Real V1_ta(unit = "m/s") "Tangential velocity at the outlet";
Real beta_2a(unit = "degree") "Runner leading edge angle";
Real beta_1a(unit = "degree") "Runner trailing edge angle";
Real W_shafta(unit = "MW") "Shaft output power";
Real bhpa(unit = "MW") "Brake horse power";
Real Ha(unit = "m") "Required net head";

//=================
//Equation Section 
equation
V2_na = v/(2*pi*r_2*b_2);
V2_ta = V2_na*tan((alpha_2a)*(pi/180));
//Multiplying by (pi/180) to convert deg to rad

V1_na = v/(2*pi*r_1*b_1);
V1_ta = V1_na*tan((alpha_1a)*(pi/180));
//Multiplying by (pi/180) to convert deg to rad

beta_2a = (atan(V2_na/((omega*r_2)-(V2_ta))))*(180/pi);
beta_1a = (atan(V1_na/((omega*r_1)-(V1_ta))))*(180/pi);
//Multiplying by (180/pi) to convert rad to deg

W_shafta = (Rho_w*omega*v*((r_2*V2_ta)-(r_1*V1_ta)))/10^6;
W_shafta = bhpa;

Ha = bhpa*10^6/(Rho_w*g*v);
//Multiplying bhpa by 10^6 to convert MW to W

end Ex14_13_a;
//==================

model Ex14_13_b
extends Modelica.Constants;
extends Ex14_13_a;

//=================
//Parameter Section
parameter Real alpha_2b(unit = "degree") = 33 "Angle in the wicket gate";
parameter Real alpha_1b(unit = "degree") = 0 "Angle in the wicket gate";

//=================
//Variable Section 
Real V2_nb(unit = "m/s") "Normal velocity component at the inlet";
Real V2_tb(unit = "m/s") "Tangential velocity at the inlet";
Real V1_nb(unit = "m/s") "Normal velocity component at the outlet";
Real V1_tb(unit = "m/s") "Tangential velocity at the outlet";
Real beta_2b(unit = "degree") "Runner leading edge angle";
Real beta_1b(unit = "degree") "Runner trailing edge angle";
Real W_shaftb(unit = "MW") "Shaft output power";
Real bhpb(unit = "MW") "Brake horse power";
Real Hb(unit = "m") "Required net head";

//=================
//Equation Section 
equation
V2_nb = v/(2*pi*r_2*b_2);

V2_tb = V2_nb*tan((alpha_2b)*(pi/180));
//Multiplying by (pi/180) to convert deg to rad

V1_nb = v/(2*pi*r_1*b_1);
V1_tb = V1_nb*tan((alpha_1b)*(pi/180));
//Multiplying by (pi/180) to convert deg to rad

beta_2b = (atan(V2_nb/((omega*r_2)-(V2_tb))))*(180/pi);
beta_1b = (atan(V1_nb/((omega*r_1)-(V1_tb))))*(180/pi);
//Multiplying by (180/pi) to convert rad to deg

W_shaftb = (Rho_w*omega*v*((r_2*V2_tb)-(r_1*V1_tb)))/10^6;
W_shaftb = bhpb;

Hb = bhpb*10^6/(Rho_w*g*v);
//Multiplying bhpa by 10^6 to convert MW to W

end Ex14_13_b;
//==================

model Ex14_13_c
extends Modelica.Constants;
extends Ex14_13_a;
extends Ex14_13_b;

//=================
//Parameter Section
parameter Real alpha_2c(unit = "degree") = 33 "Angle in the wicket gate";
parameter Real alpha_1c(unit = "degree") = -10 "Angle in the wicket gate";

//=================
//Variable Section 
Real V2_nc(unit = "m/s") "Normal velocity component at the inlet";
Real V2_tc(unit = "m/s") "Tangential velocity at the inlet";
Real V1_nc(unit = "m/s") "Normal velocity component at the outlet";
Real V1_tc(unit = "m/s") "Tangential velocity at the outlet";
Real beta_2c(unit = "degree") "Runner leading edge angle";
Real beta_1c(unit = "degree") "Runner trailing edge angle";
Real W_shaftc(unit = "MW") "Shaft output power";
Real bhpc(unit = "MW") "Brake horse power";
Real Hc(unit = "m") "Required net head";

//=================
//Equation Section 
equation
V2_nc = v/(2*pi*r_2*b_2);
V2_tc = V2_nc*tan((alpha_2c)*(pi/180));
//Multiplying by (pi/180) to convert deg to rad

V1_nc = v/(2*pi*r_1*b_1);
V1_tc = V1_nc*tan((alpha_1c)*(pi/180));
//Multiplying by (pi/180) to convert deg to rad

beta_2c = (atan(V2_nc/((omega*r_2)-(V2_tc))))*(180/pi);
beta_1c = (atan(V1_nc/((omega*r_1)-(V1_tc))))*(180/pi);
//Multiplying by (180/pi) to convert rad to deg

W_shaftc = (Rho_w*omega*v*((r_2*V2_tc)-(r_1*V1_tc)))/10^6;
W_shaftc = bhpc;
Hc = bhpc*10^6/(Rho_w*g*v);
//Multiplying bhpa by 10^6 to convert MW to W

end Ex14_13_c;
//==================

end Ex14_13;

//==================

