//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-14: Turbomachinery
//Example 14.14 Page 860
//Title: Power Generation in a Wind Farm

package Ex14_14
model Ex14_14_a
extends Modelica.Constants;

//=================
//Parameter Section
parameter Real Rho_a(unit = "kg/m3") = 1.2 "Density of air";
parameter Real V(unit = "m/s") = 12.5 "Average wind speed at a proposed HAWT wind farm site";
parameter Real Eff_gen(unit = "-") = 0.92 "Combined gearbox/generator efficiency";
parameter Real Cp(unit = "-") = 0.41 "Power coefficient";
parameter Real W_elec_out(unit = "MW") = 2.5 "Output of generator";

//=================
//Variable Section 
Real D(unit = "m") "Diameter of each turbine disk";

//=================
//Equation Section 
equation
D = sqrt((8*W_elec_out*10^6)/(Eff_gen*Cp*Rho_a*V^3*pi));
//Multiplying W_elec_out by 10^6 to convert MW to W

end Ex14_14_a;
//==================

model Ex14_14_b
extends Ex14_14_a;

//=================
//Parameter Section
parameter Real n(unit = "-") = 30 "Number of turbines on the site";
parameter Real W_elec_home(unit = "kW") = 1.5 "Electricity usage per home";
parameter Real Eff_power_dist(unit = "%") = 96 "Additional efficiency to account for the powerline losses";

//=================
//Variable Section 
Real TEP(unit = "MW") "Total electrical power produced";
Real HEP(unit = "MW") "Electrical power that actually makes it to people’s home";
Real NH(unit = "-") "Number of homes";

//=================
//Equation Section 
equation
TEP = n*W_elec_out;
HEP = (Eff_power_dist/100)*TEP;
NH = ((Eff_power_dist/100)*n*W_elec_out*10^6)/(W_elec_home*10^3);
//Multiplying W_elec_out by 10^6 to convert MW to W
//Multiplying W_elec_home by 10^3 to convert kW to W
//Dividing Eff_power_dist by 100 to convert % 

end Ex14_14_b;

end Ex14_14;
//==================
