//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-3: Pressure and Fluid Statics   
//Example 3.11  Page 103 
//Title: Height of Ice Block Below the Water Surface

model Ex3_11

//=================
//Parameter Section
parameter Real SG_I(unit = "-") = 0.92  "Specific gravity of ice";
parameter Real SG_W(unit = "-") = 1.025 " Specific gravity of sea water";
parameter Real h_IB_a(unit = "cm") = 25 "Portion of ice block extends above the water surface";
parameter Real Rho_Water(unit = "kg/m3") = 1000 "Density of water"; 
              //Reference value to calculate Density of the other from specific gravity"


//=================
//Variable Section 
Real h_IB_b(unit = "m") "Height of the ice block below the water surface";
Real Rho_I(unit = "kg/m3") "Density of ice block";
Real Rho_W(unit = "kg/m3") "Density of water";

//=================
//Equation Section
equation 
//Since,cross-sectional area of a cube is constant, volume ratio is replaced with height ratio
//Ratio = V_submerged/V_total = h_submerged/h_total = Rho_ice/Rho_water
Rho_I = SG_I*Rho_Water;
Rho_W = SG_W*Rho_Water;
h_IB_b = (Rho_I*h_IB_a*0.01)/(Rho_W-Rho_I); //Reduced form of ratio

end Ex3_11;
//=================
