//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-3: Pressure and Fluid Statics   
//Example 3.12  Page 109 
//Title: Overflow from a Water Tank During Acceleration

model Ex3_12
extends Modelica.Math;
extends Modelica.Constants;

//=================
//Parameter Section
parameter Real H(unit = "cm") = 80  "Height of the fish tank";
parameter Real V1(unit = "km/h") = 0 "Initial velocity of the truck";
parameter Real V2(unit = "km/h") = 90 "Final velocity of the truck";
parameter Real del_t(unit = "s") = 10 "Time period";
parameter Real b1(unit = "m") = 2 "Width of the tank";
parameter Real b2(unit = "m") = 0.6 "Breadth of the tank";
parameter Real g(unit = "m/s2") = 9.81 "Gravitational constant";

//=================
//Variable Section 
Real a_x(unit = "m/s2") "Acceleration of the truck - Horizontal";
Real a_z(unit = "m/s2") "Acceleration of the truck - Vertical";
Real tan_theta(unit = "-") "Tangent of the angle the free surface";
Real del_z_s1(unit = "cm") "Tank alignment - (Case 1: The long side is parallel to the direction of motion)";
Real del_z_s2(unit = "cm") "Tank alignment - (Case 2: The short side is parallel to the direction of motion)";
Real theta(unit = "degree") "Angle that free surface makes with the horizontal";

//=================
//Equation Section
equation 
a_x = (V2-V1)/(del_t*3.6);
a_z = 0 ; 
//The road is horizontal during acceleration so that acceleration has no vertical component
tan_theta = a_x/(g+a_z);
theta = (atan(tan_theta))*(180/pi);
//Multiplying theta by (180/pi) to convert rad to degree

del_z_s1 = ((b1/2)*tan_theta)*100;
del_z_s2 = ((b2/2)*tan_theta)*100;
/*The tank should definitely be oriented such that 
its short side is parallel to the direction of motion*/

end Ex3_12;
//=================
